define(['NotificationDeliveryOptions'], function() {
	'use strict';

	describe("The Notification Delivery Options directive", function (){
		var scope,
			patientPreferenceServiceMock,
			compile,
			httpMock,
			q,
			isolateScope;

		beforeEach(function () {
			module('angularTemplateApp');

			patientPreferenceServiceMock = jasmine.createSpyObj('PatientPreferenceService', ['getPreferencesData']);
			patientPreferenceServiceMock.getPreferencesData.and.returnValue({then: function() { return {finally: function() { return {} } } } });

			module(function($provide){
				$provide.value('PatientPreferenceService', patientPreferenceServiceMock);
			});

			inject(function($compile, $rootScope, $templateCache, $httpBackend, $q) {
				scope = $rootScope;
				compile = $compile;
				httpMock = $httpBackend;
				q = $q;
				$templateCache.put('modules/ui-components/form/controls/composite/notification-delivery-options/notification-delivery-options_template.html', '<div></div>');
			});

			scope.details = {
				reminder: {
					enabledFlag: false,
					notificationTypes: ["In-App", "Email"]
				}
			};
		});


		describe("the link function", function () {
			it ("should initialize variables for recurring notifications", function() {
				var element = angular.element('<div notification-delivery-options ng-model="details.reminder" is-recurring="true"></div>');
				compile(element)(scope);
				scope.$apply();

				isolateScope = element.isolateScope();
				expect(isolateScope.emailAddress).toBeNull();
				expect(isolateScope.isEmailAddressStored).toBeNull();
				expect(isolateScope.reminderTypes).toEqual([{type:"In-App"},{type:"Email"}]);
				expect(isolateScope.notificationOptions).toEqual(["On", "Off"]);
				expect(isolateScope.notificationDates).toEqual(['Daily', 'Weekly', 'Monthly']);
				expect(isolateScope.errorHandling).toEqual({
					'validNextDueDate': {
						message: 'Notifications cannot be provided for the Next Due Date you entered. Turn the Notification off to save the reminder.',
						priority: 1
					},
					'deliverySelected': {
						message: 'A Notification Delivery method is needed to save this record. Please select a method and save again.',
						priority: 2
					},
					'alertSelected': {
						message: 'The Notify Me field is needed to save this record. Please select at least one option and save again.',
						priority: 2
					}
				});
			});

			it ("should initialize variables for non-recurring notifications", function() {
				var element = angular.element('<div notification-delivery-options ng-model="details.reminder"></div>');
				compile(element)(scope);
				scope.$apply();

				isolateScope = element.isolateScope();
				expect(isolateScope.emailAddress).toBeNull();
				expect(isolateScope.isEmailAddressStored).toBeNull();
				expect(isolateScope.reminderTypes).toEqual([{type:"In-App"},{type:"Email"}]);
				expect(isolateScope.notificationOptions).toEqual(["On", "Off"]);
				expect(isolateScope.notificationDates).toEqual(['On the date', '1 day before', '2 weeks before', '4 weeks before']);
				expect(isolateScope.errorHandling).toEqual({
					'validNextDueDate': {
						message: 'Notifications cannot be provided for the Next Due Date you entered. Turn the Notification off to save the reminder.',
						priority: 1
					},
					'deliverySelected': {
						message: 'A Notification Delivery method is needed to save this record. Please select a method and save again.',
						priority: 2
					},
					'alertSelected': {
						message: 'The Notify Me field is needed to save this record. Please select at least one option and save again.',
						priority: 2
					}
				});
			});

			describe("when calling to get email address is successful", function () {
				beforeEach(function () {
					var element = angular.element('<div notification-delivery-options ng-model="details.reminder"></div>'),
						deferred = q.defer();
					deferred.resolve({emailAddress: "email"});
					patientPreferenceServiceMock.getPreferencesData.and.returnValue(deferred.promise);

					compile(element)(scope);
					scope.$apply();

					isolateScope = element.isolateScope();
				});

				it ("should call to get the user's email address", function () {
					expect(patientPreferenceServiceMock.getPreferencesData).toHaveBeenCalled();
					expect(isolateScope.emailAddress).toEqual('email');
					expect(isolateScope.isEmailAddressStored).toBe(true);
				});
			});

			describe("when calling to get email address is unsuccessful", function () {
				beforeEach(function () {
					var element = angular.element('<div notification-delivery-options ng-model="details.reminder"></div>'),
						deferred = q.defer();
					deferred.reject();
					patientPreferenceServiceMock.getPreferencesData.and.returnValue(deferred.promise);

					compile(element)(scope);
					scope.$apply();

					isolateScope = element.isolateScope();
				});

				it ("should call to get the user's email address", function () {
					expect(patientPreferenceServiceMock.getPreferencesData).toHaveBeenCalled();
					expect(isolateScope.emailAddress).toBeNull();
					expect(isolateScope.isEmailAddressStored).toBe(false);
				});
			});
		});
	});
});